//main.c for RTOS_Serial Project
//this code is modified from main.c from Salvo example files
//This software is distributed on an "as is" basis, no warranty is expressed or implied. 
//Rob Silbert Limited, LLC
//
//http://mysite.verizon.net/vze124b2u/
//Written by Rob Silbert
//rsilbert@yahoo.com
//mobile:

/*
	This file is part of pqrst commander.

    pqrst commander is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pqrst commander is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pqrst commander.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "main.h"
#include "salvo.h"
#include "commander.h"

#define TASK1_P			OSTCBP(1)
#define TASK2_P			OSTCBP(2)
#define TASK3_P			OSTCBP(3)
#define BINSEM1_P		OSECBP(1)
#define BINSEM2_P		OSECBP(2)
#define SEM_CARH		OSECSP(3)
#define REC_CHAR		OSECSP(4)

/* Global variables	*/
//DEBUG ONLY global variables help when debugger cannot watch variables
/*
unsigned char global_char1[32];
unsigned char global_char2[32];
unsigned char global_char=0;
unsigned int global_int = 0;
unsigned long global_long = 0;
unsigned global_buffer[128];
*/
//DEBUG END
/* Serial Port Memory 									*/
unsigned char receive_counter=0,current_counter=0,wdt_int_count;
unsigned char receive_buffer[32],PC_Command,configFile[256];
unsigned char login=FALSE,permission,receiveMode=COMMAND;
/*Serial  Port Prompt									*/
unsigned char PS1[16]=default_prompt,startup=TRUE;
unsigned char password_entry=FALSE;

/* use OSLabel() to create context-switching labels		*/
_OSLabel(Task1a)
//_OSLabel(Task2a)
//_OSLabel(Task3a)

/*Task 1*/
void GetSerialPortData(void)
{
	//Get data from serial port when enter key is pressed.
	//Pass the command to the Command Interpreter
static unsigned char validCommand=FALSE,i,valid_command,j;
extern unsigned char receive_buffer[32];
const unsigned char CONFIG_SIZE_MAX=48+128;
	
	while(1)
	{
		if(startup)
		{
			startup = FALSE;
			
			receive_buffer[0] = FlashRead((unsigned char *)CONFIG_FILE_ST_ADDR);
			if(receive_buffer[0] != 0xff)
			{
				//Load config file
				//load line from info memory until carriage return into configFile until EOF
				//repeat loop until EOF
				//repeat for each line
				i = 0;
				j = 0;
				
				while(receive_buffer[i] != EOT && j < CONFIG_SIZE_MAX)
				{
					i = 0;
					receive_buffer[i] = FlashRead((unsigned char *)(CONFIG_FILE_ST_ADDR + j));
					while(receive_buffer[i] != 0x0d  && receive_buffer[i] != EOT)
					{
						i++;
						j++;
						receive_buffer[i] = FlashRead((unsigned char *)(CONFIG_FILE_ST_ADDR + j));
					}
					
					//CommandCheckForValidCommand
					if(receive_buffer[0] != EOT)
					{
						validCommand = CommandCheckForValidCommand();
						j++;
						receive_buffer[i] = FlashRead((unsigned char *)(CONFIG_FILE_ST_ADDR + j + 1));
					}
				}
				UARTInitTX();
				UARTPrint("config file run complete\n");
			}
			CommandPrintStartupMessage();
		}

		while(!login)
			CommandLoginHandler();
	
		while(login)
		{
			//CommandPrintSerialPrompt();
			UARTPrint("\n");
			UARTPrint(PS1);
			UARTPrint("> ");
			while(!CommandCheckForReturnKey());
			valid_command = CommandCheckForValidCommand();

			//if(valid_command)
			//	CommandHandleCommand(valid_command);
			if(valid_command == APPLICATION_INTERNAL)
				OSSignalBinSem(BINSEM1_P);
			if(valid_command == APPLICATION_EXTERNAL)
				OSSignalBinSem(BINSEM2_P);
		}			
		//OS_Yield(Task1a);	
	}
}

/*Task 2*/
/*
void ApplicationInternal(void)
{	
	while (1) 
	{
		OS_WaitBinSem(BINSEM1_P,OSNO_TIMEOUT,Task2a);
		//Handle APPLICATION
		_NOP();
	}	
}
*/
/*Task 3*/
/*
void ApplicationExternal(void)
{
 
	//Handle external APPLICATION
	while (1) 
	{
		OS_WaitBinSem(BINSEM2_P,OSNO_TIMEOUT,Task3a);
		//Handle APPLICATION
		_NOP();
	}
	
}
*/
void main (void)
{
unsigned char priority0=0,priority1=3,priority2=5,priority3=7;
unsigned char configPresent=0;	
	//InitPORT();
	
	//Init();
	FlashPortSetup();
	/* Init UART							ROB			*/
	UARTInitTX();
	//CommandPrintStartupMessage();
	/* Initialize Salvo									*/
	OSInit();
	
	/* create tasks										*/
	OSCreateTask(GetSerialPortData, TASK1_P, priority1);
	//OSCreateTask(ApplicationInternal, TASK2_P, priority2);
	//OSCreateTask(ApplicationExternal, TASK3_P, priority3);	
	/* initialize binary semaphore to 0					*/
	//OSCreateBinSem(BINSEM1_P, priority0);
	//OSCreateBinSem(BINSEM2_P, priority3);
	
	/* enable interrupts								*/
	OSEi();
	
	/* start multitasking								*/
	while(1)
		OSSched();
		
}